"use client"

import { ClientDataWrapper } from "@/components/client.data-wrapper"
import { useListAllUsers } from "../hooks/use-list-all-users"
import { UsersTable } from "./users.table"
import { columns } from "./users.table-columns"
import { UsersTableLoading } from "./users.table.loading"

export function UsersTableClient() {
  const res = useListAllUsers();

  return (
    <ClientDataWrapper
      swr={res}
      overrides={{
        loading: (
          <UsersTableLoading
            rowCount={4}
            columns={columns}
          />
        )
      }}
      content={(data) => {
        if (!data?.verified) {
          return null;
        }

        return (
          <UsersTable data={data.verified} />
        )
      }}
    />
  )
}

